package ohd.hseb.hefs.pe.estimation.options;

import javax.swing.JComponent;
import javax.swing.JSpinner;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

import ohd.hseb.hefs.utils.VariableSetNotice;
import ohd.hseb.hefs.utils.gui.components.GenericSpinner;
import ohd.hseb.hefs.utils.gui.tools.ReachBoundsSpinnerNumberModel;
import ohd.hseb.hefs.utils.tools.GeneralTools;
import ohd.hseb.hefs.utils.xml.vars.XMLInteger;

import com.google.common.eventbus.Subscribe;

@SuppressWarnings("serial")
public class IntegerEstimationOption extends EditableLeafControlOption<Integer>
{
    private int _step;
    private Integer _min;
    private Integer _max;

    /**
     * @param xmlTag
     * @param fortranTag
     * @param label
     * @param value
     * @param step
     * @param min
     * @param max
     */
    public IntegerEstimationOption(final String xmlTag,
                                   final String label,
                                   final Integer value,
                                   final int step,
                                   final Integer min,
                                   final Integer max)
    {
        super(new XMLInteger(xmlTag, value), label);
        _step = step;
        _min = min;
        _max = max;
    }

    /**
     * @param xmlTag
     * @param fortranTag
     * @param label
     * @param value
     */
    public IntegerEstimationOption(final String xmlTag, final String label, final Integer value)
    {
        this(xmlTag, label, value, 1, null, null);
    }

    /**
     * Creates a copy with the same tags as {@code base} but with {@code value} set instead.
     * 
     * @param base
     * @param value
     */
    public IntegerEstimationOption(final IntegerEstimationOption base, final Integer value)
    {
        super(new XMLInteger(base._valueManager.getXMLTagName(), value), base._label);
        _step = base._step;
        _min = base._min;
        _max = base._max;
    }

    @Override
    public JComponent makeEditorEditor()
    {
        if(getLabel() == null)
        {
            return null;
        }
        return new Editor();
    }

    private class Editor extends GenericSpinner implements VariableSetNotice.Subscriber
    {
        private Editor()
        {
            super(new ReachBoundsSpinnerNumberModel(GeneralTools.firstNonNull(_min, _max, 0), _min, _max, _step));
            this.disableDefaultMouseWheelListener();
            final NumberEditor edit = new JSpinner.NumberEditor(this);
            edit.getFormat().setGroupingUsed(false);
            setEditor(edit);

            update();

            addChangeListener(new ChangeListener()
            {
                @Override
                public void stateChanged(final ChangeEvent e)
                {
                    set((Integer)getValue(), this);
                }
            });

            register(this);
        }

        private void update()
        {
            final Integer value = get();
            if(value != null)
            {
                setValue(value);
            }
        }

        @Override
        @Subscribe
        public void reactToVariableSet(final VariableSetNotice evt)
        {
            update();
        }
    }

    @Override
    public IntegerEstimationOption clone() throws CloneNotSupportedException
    {
        final IntegerEstimationOption copy = new IntegerEstimationOption(getXMLTagName(),
                                                                         _label,
                                                                         get(),
                                                                         _step,
                                                                         _min,
                                                                         _max);
        copy.setDefaultValue(getDefaultValue());
        return copy;
    }

    @Override
    public void copyFrom(final ControlOption base)
    {
        final IntegerEstimationOption toCopy = (IntegerEstimationOption)base;
        setXMLTagName(base.getXMLTagName());
        _step = toCopy._step;
        _min = toCopy._min;
        _max = toCopy._max;
        _label = toCopy._label;
        set(((IntegerEstimationOption)base).get());
        setDefaultValue(((GenericLeafControlOption<Integer>)base).getDefaultValue());
    }
}
