package ohd.hseb.hefs.pe.estimation.options;

import ohd.hseb.hefs.utils.xml.vars.XMLInteger;

public class IntegerNoEditEstimationOption extends GenericLeafControlOption<Integer>
{
    public IntegerNoEditEstimationOption(final String xmlTag, final Integer value)
    {
        super(new XMLInteger(xmlTag, value));
    }

    @Override
    public Object clone() throws CloneNotSupportedException
    {
        final IntegerNoEditEstimationOption copy = new IntegerNoEditEstimationOption(getXMLTagName(), get());
        copy.setDefaultValue(getDefaultValue());
        return copy;
    }

    @Override
    public void copyFrom(final ControlOption base)
    {
        setXMLTagName(base.getXMLTagName());
        set(((IntegerNoEditEstimationOption)base).get());
        setDefaultValue(((GenericLeafControlOption<Integer>)base).getDefaultValue());
    }
}
