package ohd.hseb.hefs.pe.estimation.options;

import javax.swing.JComponent;

import ohd.hseb.hefs.utils.notify.NullNotifier;
import ohd.hseb.hefs.utils.xml.XMLReader;
import ohd.hseb.hefs.utils.xml.XMLWriter;

/**
 * {@link ControlOption} that does absolutely nothing.
 * 
 * @author alexander.garbarino
 */
public class NullControlOption extends NullNotifier implements ControlOption<Void>
{
    @Override
    public XMLReader getReader()
    {
        return null;
    }

    @Override
    public String getXMLTagName()
    {
        return null;
    }

    @Override
    public XMLWriter getWriter()
    {
        return null;
    }

    @Override
    public Void get()
    {
        return null;
    }

    @Override
    public void assertValid() throws IllegalStateException
    {
    }

    @Override
    public JComponent makeEditor()
    {
        return null;
    }

    @Override
    public void setToDefault()
    {
    }

    @Override
    public int hashCode()
    {
        return 0;
    }

    @Override
    public boolean equals(final Object other)
    {
        return other instanceof NullControlOption;
    }

    @Override
    public Object clone() throws CloneNotSupportedException
    {
        return super.clone();
    }

    @Override
    public void copyFrom(final ControlOption base)
    {
    }

    @Override
    public void setDefaultValue(final Void value)
    {
    }

}
