package ohd.hseb.hefs.pe.estimation.options;

import ohd.hseb.hefs.utils.xml.vars.XMLOnOffBoolean;

public class OnOffEstimationOption extends BooleanEstimationOption
{
    public OnOffEstimationOption(final String xmlTag, final String label)
    {
        this(xmlTag, label, false);
    }

    public OnOffEstimationOption(final String xmlTag, final String label, final Boolean value)
    {
        super(new XMLOnOffBoolean(xmlTag, value), label);
    }

    @Override
    protected String writeFortranValue(final Boolean value)
    {
        return value ? "on" : "off";
    }

    @Override
    public Object clone() throws CloneNotSupportedException
    {
        final OnOffEstimationOption copy = new OnOffEstimationOption(getXMLTagName(), this._label);
        copy.set(this.get());
        copy.setDefaultValue(getDefaultValue());
        return copy;
    }

    @Override
    public void copyFrom(final ControlOption base)
    {
        setXMLTagName(base.getXMLTagName());
        set(((OnOffEstimationOption)base).get());
        setDefaultValue(((GenericLeafControlOption<Boolean>)base).getDefaultValue());
    }
}
