package ohd.hseb.hefs.pe.gui;

import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;

import ohd.hseb.hefs.pe.core.ParameterEstimatorRunInfo;
import ohd.hseb.hefs.pe.core.ParameterEstimatorSubPanel;
import ohd.hseb.hefs.pe.notice.RefreshFullDisplayNotice;

/**
 * General framework for a parameter estimator setup panel. It holds a ParameterEstimatorRunInfo instance and a list of
 * listeners, and is a ParameterEstimatorStepOptionsPanel so that it fits in the ParameterEstimatorStepsPanel. However,
 * the rest of the work, including any subpanels, must be specified in a subclass.
 * 
 * @author hank.herr
 */
@SuppressWarnings("serial")
public abstract class PESetupPanel extends ParameterEstimatorSubPanel implements TableModelListener
{
    public PESetupPanel(ParameterEstimatorRunInfo runInfo)
    {
        super(runInfo);
        initializeDisplay();
    }

    @Override
    public void tableChanged(TableModelEvent e)
    {
        // TODO is this really necessary?
        post(new RefreshFullDisplayNotice(this));
    }
}
