package ohd.hseb.hefs.pe.model;

import ohd.hseb.hefs.utils.xml.CompositeXMLReader;
import ohd.hseb.hefs.utils.xml.CompositeXMLWriter;
import ohd.hseb.hefs.utils.xml.XMLReadable;
import ohd.hseb.hefs.utils.xml.XMLWritable;
import ohd.hseb.hefs.utils.xml.vars.XMLString;

/**
 * Superclass of all algorithm specific model parameters. For example, in MEFP, it stores precipitation model parameters
 * or temperature model parameters. It only provides a version string and a getParameterFileName method.
 * 
 * @author hank.herr
 */
public abstract class AlgorithmModelParameters implements XMLReadable, XMLWritable
{
    /**
     * Parameters shared across algorithms
     */
    private final XMLString _version = new XMLString("version", "???");

    public String getVersion()
    {
        return _version.get();
    }

    public void setVersion(final String version)
    {
        _version.set(version);
    }

    /**
     * @throws Exception if the parameters are invalid. The message provides the reason.
     */
    public abstract void validateParameters() throws Exception;

    public String getXMLTagName()
    {
        return "algorithmModelParameters";
    }

    @Override
    public CompositeXMLWriter getWriter()
    {
        final CompositeXMLWriter writer = new CompositeXMLWriter(getXMLTagName());
        writer.addAttribute(_version, true);
        return writer;
    }

    @Override
    public CompositeXMLReader getReader()
    {
        final CompositeXMLReader reader = new CompositeXMLReader(getXMLTagName());
        reader.addAttribute(_version, true);
        return reader;
    }

}
