package ohd.hseb.hefs.pe.notice;

import java.util.Collection;

import ohd.hseb.hefs.pe.tools.LocationAndDataTypeIdentifier;
import ohd.hseb.hefs.utils.notify.Notice;

import com.google.common.collect.Lists;
import com.google.common.eventbus.Subscribe;

/**
 * Subscribe to this event via the {@link Subscriber} interface method
 * {@link Subscriber#reactToAvailableIdentifiersChanged(AvailableIdentifiersChangedNotice)} below. It will make it
 * easier to track those who listen for this event.
 * 
 * @author hankherr
 */
public class AvailableIdentifiersChangedNotice extends Notice
{
    private final Collection<LocationAndDataTypeIdentifier> _identifiers;

    public AvailableIdentifiersChangedNotice(final Object source,
                                             final Collection<? extends LocationAndDataTypeIdentifier> identifiers)
    {
        super(source);
        _identifiers = Lists.newArrayList(identifiers);
    }

    public Collection<LocationAndDataTypeIdentifier> getIdentifiers()
    {
        return _identifiers;
    }

    public static interface Subscriber
    {
        @Subscribe
        void reactToAvailableIdentifiersChanged(AvailableIdentifiersChangedNotice notice);
    }
}
