package ohd.hseb.hefs.pe.notice;

import ohd.hseb.hefs.mefp.tools.canonical.CanonicalEventList;
import ohd.hseb.hefs.mefp.tools.canonical.CanonicalEventsManager;
import ohd.hseb.hefs.utils.notify.Notice;

import com.google.common.eventbus.Subscribe;

/**
 * Subscribe to this event via the {@link Subscriber} interface method
 * {@link Subscriber#reactToAvailableIdentifiersChanged(CanonicalEventsCopiedNotice)} below. It will make it easier to
 * track those who listen for this event.
 * 
 * @author hankherr
 */
public class CanonicalEventsCopiedNotice extends Notice
{
    private final CanonicalEventList _copiedEventsList1;
    private final CanonicalEventList _copiedEventsList2;

    public CanonicalEventsCopiedNotice(final Object source, final CanonicalEventList copiedEventsList1)
    {
        super(source);
        _copiedEventsList1 = copiedEventsList1;
        _copiedEventsList2 = null;
    }

    public CanonicalEventsCopiedNotice(final Object source,
                                       final CanonicalEventList copiedEventsList1,
                                       final CanonicalEventList copiedEventsList2)
    {
        super(source);
        _copiedEventsList1 = copiedEventsList1;
        _copiedEventsList2 = copiedEventsList2;
    }

    /**
     * @return The list passed into {@link CanonicalEventsManager#copyEvents(CanonicalEventList)}. It is NOT the list
     *         that was updated.
     */
    public CanonicalEventList getCopiedEventsList1()
    {
        return _copiedEventsList1;
    }

    /**
     * @return The list passed into {@link CanonicalEventsManager#copyEvents(CanonicalEventList)}. It is NOT the list
     *         that was updated.
     */
    public CanonicalEventList getCopiedEventsList2()
    {
        return _copiedEventsList2;
    }

    public static interface Subscriber
    {
        @Subscribe
        void reactToCopiedCanonicalEvents(CanonicalEventsCopiedNotice notice);
    }
}
