package ohd.hseb.hefs.pe.notice;

import com.google.common.eventbus.Subscribe;

public class DisplayDiagnosticMessageNotice extends DiagnosticNotice
{
    private final String _header;
    private final String _body;

    public DisplayDiagnosticMessageNotice(Object source, String header, String body)
    {
        super(source);
        _header = header;
        _body = body;
    }

    public String getHeader()
    {
        return _header;
    }

    public String getBody()
    {
        return _body;
    }

    public interface Subscriber
    {
        @Subscribe
        void reactToDisplayDiagnosticMessage(DisplayDiagnosticMessageNotice notice);
    }
}
