package ohd.hseb.hefs.pe.notice;

import ohd.hseb.hefs.pe.core.ParameterEstimatorDiagnosticPanel;

import com.google.common.eventbus.Subscribe;

public class DisplayDiagnosticPanelNotice<T extends ParameterEstimatorDiagnosticPanel> extends DiagnosticNotice
{
    private final T _diagnosticPanel;

    public DisplayDiagnosticPanelNotice(Object source, T diagnosticPanel)
    {
        super(source);
        _diagnosticPanel = diagnosticPanel;
    }

    public T getDiagnosticPanel()
    {
        return _diagnosticPanel;
    }

    public static interface Subscriber<T extends ParameterEstimatorDiagnosticPanel>
    {
        @Subscribe
        void reactToDisplayDiagnosticPanel(DisplayDiagnosticPanelNotice<T> notice);
    }
}
