package ohd.hseb.hefs.pe.notice;

import java.util.Collection;

import ohd.hseb.hefs.pe.core.ParameterEstimatorStepProcessor;
import ohd.hseb.hefs.pe.core.StepUnit;
import ohd.hseb.hefs.utils.notify.Notice;

import com.google.common.eventbus.Subscribe;

public class GotoStepAndUnitNotice<U extends StepUnit> extends Notice
{
    private final ParameterEstimatorStepProcessor _step;
    private final Collection<U> _units;

    public GotoStepAndUnitNotice(Object source, ParameterEstimatorStepProcessor step, Collection<U> units)
    {
        super(source);
        _step = step;
        _units = units;
    }

    public ParameterEstimatorStepProcessor getStep()
    {
        return _step;
    }

    public Collection<U> getUnits()
    {
        return _units;
    }

    public interface Subscriber
    {
        @Subscribe
        void reactToGotoStepAndUnit(GotoStepAndUnitNotice notice);
    }
}
