package ohd.hseb.hefs.pe.notice;

import java.util.Collection;
import java.util.Set;

import ohd.hseb.hefs.pe.core.ParameterEstimatorRunInfo;
import ohd.hseb.hefs.pe.tools.LocationAndDataTypeIdentifier;
import ohd.hseb.hefs.utils.notify.Notice;
import ohd.hseb.hefs.utils.tools.ParameterId;

import com.google.common.collect.Sets;
import com.google.common.eventbus.Subscribe;

/**
 * This is only posted if (1) the type of parameter selected has changed (e.g., for MEFP, precip or temp) and (2) if the
 * list of available identifiers has changed, noticed by the {@link ParameterEstimatorRunInfo} receiving an
 * {@link AvailableIdentifiersChangedNotice}.
 * 
 * @author hankherr
 */
public class SelectedIdentifiersChangedNotice extends Notice
{
    private final ParameterId.Type _type;
    private final Set<LocationAndDataTypeIdentifier> _identifiers;

    public SelectedIdentifiersChangedNotice(final Object source,
                                            final ParameterId.Type type,
                                            final Collection<? extends LocationAndDataTypeIdentifier> identifiers)
    {
        super(source);
        _type = type;
        _identifiers = Sets.newHashSet(identifiers);
    }

    public ParameterId.Type getDataType()
    {
        return _type;
    }

    public Set<LocationAndDataTypeIdentifier> getIdentifiers()
    {
        return _identifiers;
    }

    public interface Subscriber
    {
        @Subscribe
        void reactToSelectedIdentifiersChanged(SelectedIdentifiersChangedNotice notice);
    }
}
