package ohd.hseb.hefs.pe.notice;

import java.util.List;

import ohd.hseb.hefs.pe.core.ParameterEstimatorStepProcessor;
import ohd.hseb.hefs.pe.core.StepUnit;
import ohd.hseb.hefs.utils.notify.Notice;

import com.google.common.collect.Lists;
import com.google.common.eventbus.Subscribe;

/**
 * Event for the run step button being enabled or disabled.
 * 
 * @author alexander.garbarino
 */
public class StepUnitsSelectedNotice extends Notice
{
    private final Class<? extends ParameterEstimatorStepProcessor> _step;
    private final List<StepUnit> _units;

    public StepUnitsSelectedNotice(Object source,
                                   Class<? extends ParameterEstimatorStepProcessor> step,
                                   Iterable<? extends StepUnit> units)
    {
        super(source);
        _step = step;
        _units = Lists.newArrayList(units);
    }

    public Class<? extends ParameterEstimatorStepProcessor> getStepClass()
    {
        return _step;
    }

    public List<StepUnit> getUnits()
    {
        return _units;
    }

    public interface Subscriber
    {
        @Subscribe
        void reactToStepProcessEnabled(StepUnitsSelectedNotice notice);
    }
}
