package ohd.hseb.hefs.pe.notice;

import java.util.Collection;

import ohd.hseb.hefs.pe.acceptance.group.ZipGroup;
import ohd.hseb.hefs.pe.core.ParameterEstimatorStepProcessor;
import ohd.hseb.hefs.pe.core.StepUnit;
import ohd.hseb.hefs.pe.tools.LocationAndDataTypeIdentifier;

import com.google.common.collect.ImmutableList;
import com.google.common.eventbus.Subscribe;

/**
 * Post these notices if the parameters or contents of a step unit changes. For example, if the lat/lon of a
 * {@link LocationAndDataTypeIdentifier} is modified or if a {@link ZipGroup} is changed. This is a subclass of
 * {@link StepUpdatedNotice} so it will trigger those subscribed methods as well. As with StepUpdatedNotice, pass in
 * {@link ParameterEstimatorStepProcessor} class to indicate the post marks the end of a run-all. <br>
 * <br>
 * 
 * @author Hank.Herr
 * @param <S> The class of the step processor that triggered the step unit update.
 * @param <U> The class of the unit.
 */
public class StepUnitsUpdatedNotice<S extends ParameterEstimatorStepProcessor, U extends StepUnit>
extends
    StepUpdatedNotice<S>
{
    private final Collection<? extends U> _units;

    public StepUnitsUpdatedNotice(final Object source, final S step, final U... units)
    {
        super(source, step);
        _units = ImmutableList.copyOf(units);
    }

    public StepUnitsUpdatedNotice(final Object source, final S step, final Collection<? extends U> units)
    {
        super(source, step);
        _units = units;
    }

    public StepUnitsUpdatedNotice(final Object source, final Class<? extends S> step, final U... units)
    {
        super(source, step);
        _units = ImmutableList.copyOf(units);
    }

    public StepUnitsUpdatedNotice(final Object source,
                                  final Class<? extends S> step,
                                  final Collection<? extends U> units)
    {
        super(source, step);
        _units = units;
    }

    public Collection<? extends U> getUnits()
    {
        return _units;
    }

    public static interface Subscriber<S extends ParameterEstimatorStepProcessor, U extends StepUnit>
    {
        @Subscribe
        void reactToStepUnitsUpdated(StepUnitsUpdatedNotice<S, U> notice);
    }
}
