package ohd.hseb.hefs.pe.notice;

import ohd.hseb.hefs.pe.core.ParameterEstimatorStepProcessor;
import ohd.hseb.hefs.utils.notify.Notice;

import com.google.common.eventbus.Subscribe;

/**
 * Indicates that a step has been performed or updated in some way. This is used to let tables know when to update
 * entire status columns, for example. If {@link #_step} is null, then it should be viewed that any or all steps may
 * have been updated. When a run-all is completed, for example, the posted event may have a null {@link #_step} to
 * indicate that all steps may have been affected.
 * 
 * @author Hank.Herr
 * @param <S> The step its connected to or null to indicate a general notice possibly applicable to any or all steps.
 */
public class StepUpdatedNotice<S extends ParameterEstimatorStepProcessor> extends Notice
{
    private final Class<? extends S> _step;

    public StepUpdatedNotice(final Object source, final S step)
    {
        super(source);
        if(step == null)
        {
            _step = null;
        }
        else
        {
            _step = (Class<? extends S>)step.getClass();
        }
    }

    public StepUpdatedNotice(final Object source, final Class<? extends S> step)
    {
        super(source);
        _step = step;
    }

    public Class<? extends S> getStep()
    {
        return _step;
    }

    public interface Subscriber
    {
        @Subscribe
        void reactToStepUpdated(StepUpdatedNotice evt);
    }
}
