package ohd.hseb.hefs.pe.notice;

import ohd.hseb.hefs.pe.acceptance.group.ZipGroup;
import ohd.hseb.hefs.pe.acceptance.group.ZipGroupInfo;
import ohd.hseb.hefs.utils.notify.Notice;

/**
 * The notice given to subscribers to a {@link ZipGroup} object that is prepared. Whenever this is fired, a similar
 * {@link ZipGroupPreparedListNotice} is fired for the {@link ZipGroupInfo} which houses this {@link ZipGroup}.
 * 
 * @author alexander.garbarino
 */
public class ZipGroupPreparedGroupNotice extends Notice
{
    private final ZipGroup _zipGroup;

    /**
     * @param source The source of the call.
     * @param zipGroup The {@link ZipGroup} that was prepared.
     */
    public ZipGroupPreparedGroupNotice(Object source, ZipGroup zipGroup)
    {
        super(source);
        _zipGroup = zipGroup;
    }

    public ZipGroup getZipGroup()
    {
        return _zipGroup;
    }

    public static interface Subscriber
    {
        public void reactToZipGroupPrepared(ZipGroupPreparedGroupNotice notice);
    }
}
