package ohd.hseb.hefs.pe.notice;

import java.util.Collection;

import ohd.hseb.hefs.pe.acceptance.group.ZipGroup;
import ohd.hseb.hefs.pe.acceptance.group.ZipGroupInfo;
import ohd.hseb.hefs.utils.notify.Notice;

/**
 * The event given to subscribers to a {@link ZipGroupInfo} object when one or more {@link ZipGroup} in that info is
 * prepared. Whenever this is fired, a similar {@link ZipGroupPreparedGroupNotice} is fired for the listeners to each of
 * the involved {@link ZipGroup} instances.
 * 
 * @author alexander.garbarino
 */
public class ZipGroupPreparedListNotice extends Notice
{
    private final ZipGroupInfo _zipGroupInfo;

    private final Collection<? extends ZipGroup> _preparedGroups;

    /**
     * @param source The source of the notice.
     * @param groupInfo The {@link ZipGroupInfo} that included some {@link ZipGroup} instances that were prepared.
     * @param preparedGroups The {@link ZipGroup} instances that were prepared, all within groupInfo.
     */
    public ZipGroupPreparedListNotice(Object source,
                                      ZipGroupInfo groupInfo,
                                      Collection<? extends ZipGroup> preparedGroups)
    {
        super(source);
        _zipGroupInfo = groupInfo;
        _preparedGroups = preparedGroups;
    }

    public ZipGroupInfo getZipGroupInfo()
    {
        return _zipGroupInfo;
    }

    /**
     * @return The {@link Collection} of {@link ZipGroup} instances that were prepared within the
     *         {@link #getZipGroupInfo()}.
     */
    public Collection<? extends ZipGroup> getPreparedGroups()
    {
        return _preparedGroups;
    }

    public static interface Subscriber
    {
        public void reactToZipGroupPreparedList(ZipGroupPreparedListNotice notice);
    }
}
