package ohd.hseb.hefs.pe.notice;

import ohd.hseb.hefs.pe.acceptance.group.ZipGroup;
import ohd.hseb.hefs.pe.acceptance.group.ZipGroupInfo;
import ohd.hseb.hefs.pe.tools.LocationAndDataTypeIdentifier;
import ohd.hseb.hefs.utils.notify.collect.CollectionModifiedNotice;

import com.google.common.eventbus.Subscribe;

/**
 * The event given to subscribers to a {@link ZipGroup} object when its name is changed. Whenever this is fired, a
 * similar {@link ZipGroupRenamedListNotice} is fired for listeners to the {@link ZipGroupInfo} which this is in.
 * 
 * @author alexander.garbarino
 */
public class ZipGroupRenamedGroupNotice extends CollectionModifiedNotice<LocationAndDataTypeIdentifier, ZipGroup>
{
    private final String _oldName;

    public ZipGroupRenamedGroupNotice(Object source, ZipGroup zipGroup, String oldName)
    {
        super(source, zipGroup);
        _oldName = oldName;
    }

    public String getOldName()
    {
        return _oldName;
    }

    public static interface Subscriber
    {
        @Subscribe
        void reactToZipGroupRenamed(ZipGroupRenamedGroupNotice notice);
    }
}
