package ohd.hseb.hefs.pe.notice;

import ohd.hseb.hefs.pe.acceptance.group.ZipGroup;
import ohd.hseb.hefs.pe.acceptance.group.ZipGroupInfo;
import ohd.hseb.hefs.utils.notify.collect.ElementsChangedNotice;

import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;

/**
 * The event given to subscribers to a {@link ZipGroupInfo} object when a {@link ZipGroup} in that info is renamed.
 * Whenever this is fired, a similar {@link ZipGroupRenamedGroupNotice} is fired for the listeners to the specific
 * {@link ZipGroup}.
 * 
 * @author alexander.garbarino
 */
public class ZipGroupRenamedListNotice extends ElementsChangedNotice<ZipGroup, ZipGroupInfo>
{
    private final String _oldName;

    public ZipGroupRenamedListNotice(Object source, ZipGroupInfo info, ZipGroup group, String oldName)
    {
        super(source, info, Lists.<ZipGroup>newArrayList(group));
        _oldName = oldName;
    }

    public ZipGroup getGroup()
    {
        return Iterables.getOnlyElement(getChangedElements());
    }

    public String getOldName()
    {
        return _oldName;
    }

    public static interface Subscriber extends ElementsChangedNotice.Subscriber<ZipGroup, ZipGroupInfo>
    {
    }
}
