package ohd.hseb.hefs.pe.setup;

import static com.google.common.collect.Lists.newArrayList;

import java.awt.Color;
import java.util.List;

import nl.wldelft.util.timeseries.TimeSeriesArray;
import ohd.hseb.charter.ChartEngine;
import ohd.hseb.hefs.pe.tools.DiagnosticChartBuilder;
import ohd.hseb.hefs.pe.tools.LocationAndDataTypeIdentifier;
import ohd.hseb.hefs.pe.tools.TimeSeriesChartDiagnosticPanel;

@SuppressWarnings("serial")
public class ExportPIXMLDiagnosticPanel extends TimeSeriesChartDiagnosticPanel
{
    private final static Color QUESTIONABLE_MARK = new Color(255, 0, 0, 64); // red
    private final static Color QUESTIONABLE_ZONE = new Color(255, 0, 0, 64); // red

    private String _diagnosticPanelFileName;

    @Override
    protected boolean hasYearSpinner()
    {
        return false;
    }

    @Override
    protected boolean hasForecastList()
    {
        return false;
    }

    @SuppressWarnings("unchecked")
    public ExportPIXMLDiagnosticPanel(final LocationAndDataTypeIdentifier identifier, final TimeSeriesArray series)
    {
        super(identifier, newArrayList(series));
        updateChart();
    }

    @SuppressWarnings("unchecked")
    public ExportPIXMLDiagnosticPanel(final LocationAndDataTypeIdentifier identifier,
                                      final List<TimeSeriesArray> series,
                                      final String diagnosticPanelFileName)
    {
        super(identifier, series);
        _diagnosticPanelFileName = diagnosticPanelFileName;
        updateChart();

    }

    @Override
    protected ChartEngine buildChart() throws Exception
    {
        final DiagnosticChartBuilder builder = new DiagnosticChartBuilder(getIdentifier(),
                                                                          _diagnosticPanelFileName,
                                                                          "ExportPIXML",
                                                                          getAllSeries())
        {
            @Override
            protected void prepareChart() throws Exception
            {
                super.prepareChart();

                //Change specific to ExportPIXMLDiagnosticPanel.  
                //Need to make sure the legend entry displays the parameter id.
                int index = 0;
                for(final TimeSeriesArray ts: getTimeSeriesInDisplayedOrder())
                {
                    _engine.getChartParameters()
                           .getDataSourceParameters(0)
                           .getSeriesDrawingParametersForSeriesIndex(index)
                           .setNameInLegend(ts.getHeader().getParameterId());
                    index++;
                }
            }
        };
        builder.addDomainThresholdsForQuestionableValues(QUESTIONABLE_MARK, QUESTIONABLE_ZONE);
        return builder.buildChartEngine();
    }
}
