package ohd.hseb.hefs.pe.setup;

import java.io.File;

import javax.swing.JFileChooser;
import javax.swing.JOptionPane;

import ohd.hseb.hefs.pe.core.ParameterEstimatorRunInfo;
import ohd.hseb.hefs.pe.core.ParameterEstimatorTableModel;
import ohd.hseb.hefs.pe.notice.AvailableIdentifiersChangedNotice;
import ohd.hseb.hefs.pe.sources.pixml.GenericPIXMLDataHandler;
import ohd.hseb.hefs.utils.filechooser.HGlobalFileChooser;
import ohd.hseb.hefs.utils.gui.jtable.models.AddDeleteRowTableModel;
import ohd.hseb.hefs.utils.gui.jtable.models.AddDeleteTableModelWrapper;
import ohd.hseb.hefs.utils.gui.jtable.models.PreferredWidthsTableModel;
import ohd.hseb.hefs.utils.gui.tools.SwingTools;

@SuppressWarnings("serial")
public class PIXMLFilesFoundTableModel extends AddDeleteTableModelWrapper
{
    //private static final String ADD_STR = "Add exported PI-XML file";
    private static final String DEL_STR = "Delete exported PI-XML file";

    public PIXMLFilesFoundTableModel(final ParameterEstimatorRunInfo runInfo, final GenericPIXMLDataHandler handler)
    {
        //To include an add row, change null to ADD_STR and uncomment the constant above.
        //Also, the run info does not record added files, so it will need to be overhauled.
        super(new InnerTableModel(runInfo, handler), null, DEL_STR);
    }

    private static class InnerTableModel extends ParameterEstimatorTableModel implements PreferredWidthsTableModel,
    AddDeleteRowTableModel
    {
        private static final Class<?>[] COLUMN_CLASSES = {String.class, Integer.class, Integer.class};
        private static final String[] COLUMN_NAMES = {"Filename", "# Found", "# Used"};
        private static final Integer[] COLUMN_WIDTHS = {300, 30, 30};

        private GenericPIXMLDataHandler _handler = null;

        private InnerTableModel(final ParameterEstimatorRunInfo runInfo, final GenericPIXMLDataHandler handler)
        {
            super(runInfo);
            _handler = handler;
        }

        @Override
        public Class<?> getColumnClass(final int columnIndex)
        {
            if(0 <= columnIndex && columnIndex < COLUMN_CLASSES.length)
            {
                return COLUMN_CLASSES[columnIndex];
            }
            return String.class;
        }

        @Override
        public Integer getPreferredWidth(final int column)
        {
            if(0 <= column && column <= COLUMN_WIDTHS.length)
            {
                return COLUMN_WIDTHS[column];
            }
            return null;
        }

        @Override
        public String getColumnName(final int column)
        {
            if(0 <= column && column < COLUMN_NAMES.length)
            {
                return COLUMN_NAMES[column];
            }
            return "ERROR";
        }

        @Override
        public int getRowCount()
        {
            if(_handler == null)
            {
                return 0;
            }
            return _handler.getPIXMLFileNamesRead().size();
        }

        @Override
        public int getColumnCount()
        {
            return 3;
        }

        @Override
        public Object getValueAt(final int row, final int column)
        {
            //Get the source for the row or null if this is the last row (the add row).
            Object sourceForRow = null;
            if(row < getRowCount())
            {
                sourceForRow = _handler.getPIXMLFileNamesRead().get(row);
            }

            if(column == 0)
            {
                if(sourceForRow instanceof String)
                {
                    final String baseDirectory = _handler.getPIXMLDataDirectory().getAbsolutePath();
                    if(((String)sourceForRow).startsWith(baseDirectory + File.separator))
                    {
                        return ((String)sourceForRow).substring(baseDirectory.length() + 1);
                    }
                }
                return sourceForRow;

            }
            else if(column == 1)
            {
                return _handler.getOriginalIdentifiersFoundForSource(sourceForRow).size();
            }
            else if(column == 2)
            {
                return _handler.getOriginalIdentifiersUsedFromSource(sourceForRow).size();
            }

            return null;
        }

        @Override
        public boolean isCellEditable(final int row, final int column)
        {
            return false;
        }

        @Override
        public String getColumnHeaderToolTip(final int modelColIndex)
        {
            if(modelColIndex == 1)
            {
                return "Number of time series found in the file.";
            }
            else if(modelColIndex == 2)
            {
                return "Number of time series that are usable (i.e., not empty).";
            }
            return "";
        }

        @Override
        public String getCellToolTip(final int rowIndex, final int modelColIndex)
        {
            if(modelColIndex == 1)
            {
                return "Number of time series found in the file.";
            }
            else if(modelColIndex == 2)
            {
                return "Number of time series that are usable (i.e., not empty).";
            }
            return "";
        }

        @Override
        public void addRow()
        {
            final HGlobalFileChooser fileChooser = new HGlobalFileChooser(this._handler.getPIXMLDataDirectory()
                                                                                       .getParent());
            fileChooser.addFileFilter("fi", "FastInfoset File");
            fileChooser.addFileFilter("xml", "XML File");
            fileChooser.setDialogTitle("Select PI-XML Time Series File");
            final File file = fileChooser.chooseFile(JFileChooser.FILES_ONLY, getTable());
            if(file == null)
            {
                return;
            }

            try
            {
                final int oldRows = getRowCount();
                _handler.addFileToRead(file.getAbsolutePath(), true);
                _handler.readUnreadHistoricalFilesAndAddToLists();
                this.fireTableRowsInserted(oldRows, oldRows);
                post(new AvailableIdentifiersChangedNotice(this, getRunInfo().getAvailableIdentifiers()));
            }
            catch(final Exception e)
            {
                JOptionPane.showMessageDialog(SwingTools.getGlobalDialogParent(getTable()),
                                              e.getMessage(),
                                              "Unable To Add File!",
                                              JOptionPane.WARNING_MESSAGE);
            }
        }

        @Override
        public void deleteRow(final int indexOfRowClicked, final int[] allTableSelectedIndices)
        {
            final int option = JOptionPane.showConfirmDialog(SwingTools.getGlobalDialogParent(getTable()),
                                                             "Are you sure you wish to delete the file "
                                                                 + _handler.getPIXMLFileNamesRead()
                                                                           .get(indexOfRowClicked) + "?\n",
                                                             "Confirm File Deletion",
                                                             JOptionPane.YES_NO_OPTION);
            if(option == JOptionPane.YES_OPTION)
            {
                _handler.deleteFileRead(_handler.getPIXMLFileNamesRead().get(indexOfRowClicked));
                this.fireTableRowsDeleted(indexOfRowClicked, indexOfRowClicked);
                getRunInfo().notifyAvailableIdentifiersChanged(this);
                //post(new AvailableIdentifiersChangedNotice(this, getRunInfo().getAvailableIdentifiers()));
            }
        }
    }
}