package ohd.hseb.hefs.pe.setup;

import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

import javax.swing.JTable;

import ohd.hseb.hefs.pe.core.ParameterEstimatorRunInfo;
import ohd.hseb.hefs.pe.core.ParameterEstimatorStepProcessor;
import ohd.hseb.hefs.pe.sources.pixml.GenericPIXMLDataHandler;
import ohd.hseb.hefs.pe.tools.GenericSummaryTableModel;
import ohd.hseb.hefs.pe.tools.GenericSummaryTableStatusProvider;
import ohd.hseb.hefs.pe.tools.LocationAndDataTypeIdentifier;
import ohd.hseb.hefs.utils.gui.jtable.models.RowCheckableTableModel;
import ohd.hseb.hefs.utils.status.StatusLabel;
import ohd.hseb.hefs.utils.tools.ListTools;

public class PIXMLLocationSummaryTableModel extends GenericSummaryTableModel implements RowCheckableTableModel
{
    private static final long serialVersionUID = 1L;

    public static String NO_MAPPED_STATION_ID = "-none-";

    private final List<Boolean> _checkedState = new ArrayList<Boolean>();

    public PIXMLLocationSummaryTableModel(final ParameterEstimatorRunInfo runInfo,
                                          final Class<? extends ParameterEstimatorStepProcessor> step,
                                          final GenericPIXMLDataHandler handler)
    {
        super(runInfo, new Provider(handler));
    }

    @Override
    public void checkSelected()
    {
        final int[] selectedRows = getTable().getSelectedRows();
        for(final int i: selectedRows)
        {
            this._checkedState.set(i, true);
        }
        this.fireTableDataChanged();
    }

    @Override
    public void uncheckSelected()
    {
        final int[] selectedRows = getTable().getSelectedRows();
        for(final int i: selectedRows)
        {
            this._checkedState.set(i, false);
        }
        this.fireTableDataChanged();
    }

    @Override
    public void checkAll()
    {
        ListTools.setAll(_checkedState, true);
        this.fireTableDataChanged();
    }

    @Override
    public void uncheckAll()
    {
        ListTools.setAll(_checkedState, false);
        this.fireTableDataChanged();
    }

    /**
     * Wrapping addTable.
     * 
     * @param table
     */
    public void setContainingTable(final JTable table)
    {
        if(getTable() != null)
        {
            removeTable(getTable());
        }
        addTable(table);
    }

    public List<LocationAndDataTypeIdentifier> getIdentifiersToExport()
    {
        final ArrayList<LocationAndDataTypeIdentifier> identifiers = new ArrayList<LocationAndDataTypeIdentifier>();
        for(int i = 0; i < _checkedState.size(); i++)
        {
            if(_checkedState.get(i))
            {
                identifiers.add(this.getIdentifier(i));
            }
        }
        return identifiers;
    }

    @Override
    public void setIdentifiers(final Collection<LocationAndDataTypeIdentifier> identifiers)
    {
        super.setIdentifiers(identifiers);
        for(int i = 0; i < getRowCount(); i++)
        {
            _checkedState.add(false);
        }
    }

    @Override
    public int getColumnCount()
    {
        //Will not display coordinate columns, since coordinates are not known when this is displayed.
        return 6;
    }

    @Override
    public String getColumnName(final int column)
    {
        if(column == 5)
        {
            return "Export?";
        }
        return super.getColumnName(column);
    }

    @Override
    public Object getValueAt(final int row, final int column)
    {
        if(column == 5)
        {
            return this._checkedState.get(row);
        }
        return super.getValueAt(row, column);
    }

    @Override
    public Class<?> getColumnClass(final int columnIndex)
    {
        if(columnIndex == 5)
        {
            return Boolean.class;
        }
        return super.getColumnClass(columnIndex);
    }

    @Override
    public String getColumnHeaderToolTip(final int visibleColIndex)
    {
        return super.getColumnHeaderToolTip(visibleColIndex);
    }

    @Override
    public String getCellToolTip(final int rowIndex, final int visibleColIndex)
    {
        return super.getCellToolTip(rowIndex, visibleColIndex);
    }

    @Override
    public void setValueAt(final Object aValue, final int rowIndex, final int columnIndex)
    {
        if(columnIndex == 5)
        {
            this._checkedState.set(rowIndex, (Boolean)aValue);
        }
    }

    @Override
    public boolean isCellEditable(final int row, final int column)
    {
        return (column == 5);
    }

    private static class Provider implements GenericSummaryTableStatusProvider
    {
        private final GenericPIXMLDataHandler _handler;

        private Provider(final GenericPIXMLDataHandler handler)
        {
            _handler = handler;
        }

        @Override
        public String getStatusColumnName()
        {
            return "Done?";
        }

        @Override
        public String getToolTipForColumnHeader()
        {
            return "Indicates if an exported historical file already contains the location and data type.";
        }

        @Override
        public StatusLabel getStatus(final LocationAndDataTypeIdentifier identifier)
        {
            final File checkFile = new File(_handler.buildFullPathNameForPIXMLFileFromFileName(identifier.getFiFilename()));
            if((checkFile.exists()) || (_handler.getIdentifiersWithData().contains(identifier)))
            {
                return StatusLabel.make(true, "An exported historical data file was found containing data for "
                    + identifier.buildStringToDisplayInTree());
            }
            else
            {
                return StatusLabel.make(false, "No exported historical data file was found containing data for "
                    + identifier.buildStringToDisplayInTree());
            }
        }
    }
}
