package ohd.hseb.hefs.pe.sources;

import java.io.File;
import java.util.Collection;
import java.util.List;

import nl.wldelft.util.timeseries.TimeSeriesArray;
import ohd.hseb.hefs.pe.tools.LocationAndDataTypeIdentifier;
import ohd.hseb.hefs.utils.notify.NotifierBase;

import com.google.common.collect.Lists;

/**
 * Abstract default implementation of SourceDataHandler
 * 
 * @author hank.herr
 */
public abstract class AbstractSourceDataHandler extends NotifierBase implements SourceDataHandler
{
    private File _baseDirectory;

    @Override
    public void setDataHandlerBaseDirectory(File directory)
    {
        _baseDirectory = directory;
    }

    @Override
    public File getDataHandlerBaseDirectory()
    {
        return _baseDirectory;
    }

    @Override
    public void loadOriginalTimeSeries(List<LocationAndDataTypeIdentifier> identifiers) throws Exception
    {
        throw new UnsupportedOperationException(getClass().getName() + " cannot load original time series");
    }

    @Override
    public void loadPreparedTimeSeries(List<LocationAndDataTypeIdentifier> identifiers) throws Exception
    {
        throw new UnsupportedOperationException(getClass().getName() + " cannot load prepared time series");
    }

    @Override
    public Collection<TimeSeriesArray> getLoadedObservedTimeSeries(LocationAndDataTypeIdentifier identifier)
    {
        return Lists.newArrayList();
    }

    @Override
    public Collection<TimeSeriesArray> getLoadedForecastTimeSeries(LocationAndDataTypeIdentifier identifier)
    {
        return Lists.newArrayList();
    }

    @Override
    public Collection<TimeSeriesArray> getAllLoadedObservedTimeSeries()
    {
        return Lists.newArrayList();
    }

    @Override
    public Collection<TimeSeriesArray> getAllLoadedForecastTimeSeries()
    {
        return Lists.newArrayList();
    }

    @Override
    public void initialize() throws Exception
    {
    }

    @Override
    public void prepareDataFiles() throws Exception
    {
        new UnsupportedOperationException("No need to prepare data files").printStackTrace();
    }

}
