package ohd.hseb.hefs.pe.tools;

import static ohd.hseb.hefs.utils.tools.IconTools.getHSEBIcon;

import javax.swing.AbstractAction;
import javax.swing.Icon;

import ohd.hseb.hefs.mefp.sources.rfcfcst.database.ConnectionTestedNotice;

import com.google.common.eventbus.Subscribe;

@SuppressWarnings("serial")
public abstract class ConnectionAction extends AbstractAction implements ConnectionTestedNotice.Subscriber
{
    private final Icon _onIcon;
    private final Icon _offIcon;
    private final String _onTooltip;
    private final String _offTooltip;

    public ConnectionAction()
    {
        this("Connected.", "Could not connect.");
    }

    public ConnectionAction(String onTooltip, String offTooltip)
    {
        this(getHSEBIcon("serverOK20x20"), onTooltip, getHSEBIcon("serverError20x20"), offTooltip);
    }

    public ConnectionAction(Icon onIcon, String onTooltip, Icon offIcon, String offTooltip)
    {
        super();
        _onIcon = onIcon;
        _onTooltip = onTooltip;
        _offIcon = offIcon;
        _offTooltip = offTooltip;
        putValue(SMALL_ICON, getHSEBIcon("server20x20"));
    }

    @Override
    @Subscribe
    public void reactToConnectionTested(ConnectionTestedNotice evt)
    {
        setConnected(evt.canConnect());
    }

    private void setConnected(boolean connected)
    {
        if(connected)
        {
            putValue(SMALL_ICON, _onIcon);
            putValue(SHORT_DESCRIPTION, _onTooltip);
        }
        else
        {
            putValue(SMALL_ICON, _offIcon);
            putValue(SHORT_DESCRIPTION, _offTooltip);
        }
        // Force display update.
        setEnabled(!enabled);
        setEnabled(!enabled);
    }
}
