package ohd.hseb.hefs.pe.tools;

public class DataTypeIdentifier
{

    public final String _id;

    public DataTypeIdentifier(String dataType)
    {
        _id = dataType;
    }

    public boolean isPrecipitation()
    {
        return _id.toLowerCase().contains("precip") || HEFSTools.isPrecipitationDataType(_id);
    }

    public boolean isTemperature()
    {
        return _id.toLowerCase().contains("temp") || HEFSTools.isTemperatureDataType(_id);
    }

    public boolean isStreamflow()
    {
        return HEFSTools.isStreamflowDataType(_id);
    }

    public String getId()
    {
        return _id;
    }

    @Override
    public String toString()
    {
        return _id;
    }
}
