package ohd.hseb.hefs.pe.tools;

import ohd.hseb.hefs.pe.core.ParameterEstimatorStepProcessor;
import ohd.hseb.hefs.utils.status.StatusIndicator;

/**
 * Default implementation of a GenericSummaryTableStatusProvider that wraps a ParameterEstimatorStepProcessor.
 * 
 * @author hank.herr
 */
public class DefaultStepTableStatusProvider implements GenericSummaryTableStatusProvider
{
    private final ParameterEstimatorStepProcessor _stepProcessor;

    public DefaultStepTableStatusProvider(ParameterEstimatorStepProcessor stepProcessor)
    {
        _stepProcessor = stepProcessor;
    }

    @Override
    public String getStatusColumnName()
    {
        return "Status";
    }

    @Override
    public String getToolTipForColumnHeader()
    {
        return _stepProcessor.getToolTipTextForIdentifierTableColumnHeader();
    }

    @Override
    public StatusIndicator getStatus(LocationAndDataTypeIdentifier identifier)
    {
        return _stepProcessor.getStatus(identifier);
    }
}
