package ohd.hseb.hefs.pe.tools;

import ohd.hseb.hefs.utils.status.StatusIndicator;

/**
 * An implementer can be used to provide status information for a column displayed in the table within a
 * GenericSummaryTablePanel.
 * 
 * @author hank.herr
 */
public interface GenericSummaryTableStatusProvider
{
    /**
     * @return The column name to display in the table.
     */
    public String getStatusColumnName();

    /**
     * @return The tool tip to provide for the column header.
     */
    public String getToolTipForColumnHeader();

    /**
     * Get the status of the identifier.
     */
    public StatusIndicator getStatus(LocationAndDataTypeIdentifier identifier);
}
