package ohd.hseb.hefs.pe.tools;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;

import ohd.hseb.hefs.utils.effect.Effect;
import ohd.hseb.hefs.utils.notify.collect.NotifyingListWrapper;
import ohd.hseb.hefs.utils.tools.ParameterId;
import ohd.hseb.hefs.utils.xml.CompositeXMLWriter;
import ohd.hseb.hefs.utils.xml.ListXMLReader;
import ohd.hseb.hefs.utils.xml.XMLReadable;
import ohd.hseb.hefs.utils.xml.XMLReader;
import ohd.hseb.hefs.utils.xml.XMLWritable;
import ohd.hseb.hefs.utils.xml.XMLWriter;
import ohd.hseb.util.misc.HString;

public class LocationAndDataTypeIdentifierList
extends
    NotifyingListWrapper<LocationAndDataTypeIdentifier, List<LocationAndDataTypeIdentifier>> implements XMLReadable,
XMLWritable
{
    public static final String XML_TAG = "hefsIdentifierList";

    public LocationAndDataTypeIdentifierList()
    {
        super(new ArrayList<LocationAndDataTypeIdentifier>());
    }

    public LocationAndDataTypeIdentifierList(Collection<LocationAndDataTypeIdentifier> base)
    {
        this();
        this.addAll(base);
    }

    /**
     * Creates a copy of this list containing only the identifiers of the specified type
     * 
     * @param type the type of parameter to search for
     * @return a new list with only identifiers of the specified type
     */
    public LocationAndDataTypeIdentifierList ofType(ParameterId.Type type)
    {
        LocationAndDataTypeIdentifierList list = new LocationAndDataTypeIdentifierList();
        for(LocationAndDataTypeIdentifier identifier: this)
        {
            if(ParameterId.valueOf(identifier.getParameterId())._type == type)
            {
                list.add(identifier);
            }
        }
        return list;
    }

    public boolean checkForFullEquality(LocationAndDataTypeIdentifierList other)
    {
        if(other.size() != this.size())
        {
            return false;
        }
        for(int i = 0; i < size(); i++)
        {
            if(!get(i).checkForFullEquality(other.get(i)))
            {
                return false;
            }
        }
        return true;
    }

    public String buildListOfIdentifierStrings()
    {
        List<String> strings = new ArrayList<String>();
        for(LocationAndDataTypeIdentifier identifier: this)
        {
            strings.add(identifier.buildStringToDisplayInTree());
        }
        return HString.buildStringFromList(strings, ",");
    }

    /**
     * Merge the given {@link LocationAndDataTypeIdentifier} instances with those in this list. Any locations that do no
     * already exist in the last will be added. Otherwise, the mapped information for the one in this list will be set
     * to the mapped location information in the merged version. This will never change the base location information
     * (lat and lon) based on the provided toMerge list.
     * 
     * @param toMerge List of locations to merge.
     */
    public void mergeLocations(List<LocationAndDataTypeIdentifier> toMerge)
    {
        for(LocationAndDataTypeIdentifier mergedLocation: toMerge)
        {
            // Add the merged location, using the merged coordinates.
            if(!contains(mergedLocation))
            {
                add(mergedLocation);
            }
            // Otherwise, assume the base coordinates (lat/lon) are
            // already as desired, and override the mapped
            // information only.
            else
            {
                LocationAndDataTypeIdentifier working = get(indexOf(mergedLocation));
                working.setMappedLocation(mergedLocation.getMappedLocationId(),
                                          mergedLocation.getMappedLocationLatitude(),
                                          mergedLocation.getMappedLocationLongitude());
            }
        }
        Collections.sort(this);
    }

    @Override
    public XMLWriter getWriter()
    {
        return new CompositeXMLWriter(getXMLTagName(), this);
    }

    public String getXMLTagName()
    {
        return XML_TAG;
    }

    @Override
    public XMLReader getReader()
    {
        Effect<List<LocationAndDataTypeIdentifierSupplier>> addIdentifiers;
        addIdentifiers = new Effect<List<LocationAndDataTypeIdentifierSupplier>>()
        {
            @Override
            public void perform(List<LocationAndDataTypeIdentifierSupplier> input)
            {
                for(LocationAndDataTypeIdentifierSupplier supplier: input)
                {
                    LocationAndDataTypeIdentifier identifier = supplier.get();
                    if(!contains(identifier))
                    {
                        add(identifier);
                    }
                }
            }
        };
        return new ListXMLReader(getXMLTagName(), LocationAndDataTypeIdentifierSupplier.DEFAULT_FACTORY, addIdentifiers);
    }

}
