package ohd.hseb.hefs.pe.tools;

import ohd.hseb.hefs.utils.xml.XMLReader;
import ohd.hseb.hefs.utils.xml.XMLReaderException;
import ohd.hseb.hefs.utils.xml.XMLTools;
import ohd.hseb.hefs.utils.xml.XMLWriter;
import ohd.hseb.hefs.utils.xml.XMLWriterException;

import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.xml.sax.Attributes;

public class LocationIdentifier implements XMLReader, XMLWriter
{
    private boolean _ready;
    private String _id;

    // For reading XML only.
    public LocationIdentifier()
    {
        _ready = false;
    }

    public LocationIdentifier(final String location)
    {
        _id = location;
        _ready = true;
    }

    public String getId()
    {
        if(!_ready)
        {
            throw new IllegalStateException("This location has not yet been read in.");
        }
        return _id;
    }

    @Override
    public boolean equals(final Object other)
    {
        return this.toString().equals(other.toString());
    }

    @Override
    public int hashCode()
    {
        return this.toString().hashCode();
    }

    @Override
    public String toString()
    {
        return _id;
    }

    @Override
    public Element writePropertyToXMLElement(final Document request) throws XMLWriterException
    {
        return XMLTools.createTextNodeElement(request, getXMLTagName(), _id);
    }

    @Override
    public String getXMLTagName()
    {
        return "locationId";
    }

    @Override
    public void setValueOfElement(final String elementName, final String value) throws XMLReaderException
    {
        if(getXMLTagName().equals(elementName))
        {
            if(_ready)
            {
                throw new XMLReaderException("This location has already been read in.");
            }
            _ready = true;
            _id = value;
        }
        else
        {
            throw new XMLReaderException("Unknown tag " + elementName);
        }
    }

    @Override
    public XMLReader readInPropertyFromXMLElement(final String elementName, final Attributes attr) throws XMLReaderException
    {
        return null;
    }

    @Override
    public void finalizeReading() throws XMLReaderException
    {
    }

    @Override
    public void validate() throws XMLReaderException
    {
    }

    @Override
    public XMLReader getReader()
    {
        return this;
    }

    @Override
    public XMLWriter getWriter()
    {
        return this;
    }
}
