package ohd.hseb.hefs.pe.tools;

import ohd.hseb.hefs.pe.core.ParameterEstimatorRunInfo;
import ohd.hseb.hefs.pe.core.ParameterEstimatorSubPanel;

import com.google.common.eventbus.Subscribe;

@SuppressWarnings("serial")
public abstract class SubEditor extends ParameterEstimatorSubPanel
{
    public SubEditor(ParameterEstimatorRunInfo runInfo)
    {
        super(runInfo);
    }

    public static class SubEditorNotice extends ohd.hseb.hefs.utils.notify.Notice
    {
        private final SubEditor _subEditor;

        /**
         * @param source whatever created the sub editor
         * @param subEditor the actual sub editor
         */
        public SubEditorNotice(Object source, SubEditor subEditor)
        {
            super(source);
            _subEditor = subEditor;
        }

        public SubEditor getSubEditor()
        {
            return _subEditor;
        }
    }

    /**
     * Notifies that a sub-editor was 'created', and should be added to the gui.
     * 
     * @author alexander.garbarino
     */
    public static class CreatedNotice extends SubEditorNotice
    {
        /**
         * @param source whatever created the sub editor
         * @param subEditor the actual sub editor
         */
        public CreatedNotice(Object source, SubEditor subEditor)
        {
            super(source, subEditor);
        }

        public interface Subscriber
        {
            @Subscribe
            void reactToSubEditorCreated(CreatedNotice notice);
        }
    }

    /**
     * Notifies that a sub-editor was 'destroyed', and should be removed from the gui.
     * 
     * @author alexander.garbarino
     */
    public static class DestroyedNotice extends SubEditorNotice
    {
        /**
         * @param source whatever created the sub editor
         * @param subEditor the actual sub editor
         */
        public DestroyedNotice(Object source, SubEditor subEditor)
        {
            super(source, subEditor);
        }

        public interface Subscriber
        {
            @Subscribe
            void reactToSubEditorDestroyed(DestroyedNotice notice);
        }
    }
}
