package ohd.hseb.hefs.utils;

import com.google.common.base.Function;

public abstract class AbstractFunction<F, T> implements Function<F, T>
{
    /**
     * Returns {@code outerFunction} composed with this function.
     * 
     * @param <NewT> the new return type of the function
     * @param outerFunction the function to compose this function with
     * @return the composition of {@code outerFunction} and this
     */
    @SuppressWarnings({"unchecked", "rawtypes"})
    public <NewT> Function<F, NewT> andThen(final Function<T, NewT> outerFunction)
    {
        return new CompositeFunction(this, outerFunction);
    }
}
