package ohd.hseb.hefs.utils;

import com.google.common.base.Function;

/**
 * {@link Function} that expects two input values in order to generate one output.
 * 
 * @author Hank.Herr
 * @param <F0> First input
 * @param <F1> Second input
 * @param <T> Output
 */
public abstract class BinaryFunction<F0, F1, T> extends AbstractFunction<Dyad<F0, F1>, T>
{
    @Override
    public T apply(final Dyad<F0, F1> input)
    {
        return apply(input.getFirst(), input.getSecond());
    }

    /**
     * This is a conditional version of the apply. Given F0, it returns a function that maps F1 to T. Example use: T
     * result = apply(F0 input0).apply(F1 input1) (equivalent to: T results = apply(input0, input 1).
     * 
     * @param input0 The first input to use.
     * @return Function that maps the second input to a final result given the first input.
     */
    public AbstractFunction<F1, T> conditionOn(final F0 input0)
    {
        return new AbstractFunction<F1, T>()
        {
            @Override
            public T apply(final F1 input1)
            {
                return BinaryFunction.this.apply(input0, input1);
            }
        };
    }

    /**
     * Must return result given the two inputs.
     * 
     * @see #apply(Dyad).
     */
    public abstract T apply(F0 input0, F1 input1);
}
