package ohd.hseb.hefs.utils;

import java.util.List;

import com.google.common.base.Function;
import com.google.common.base.Joiner;
import com.google.common.collect.Lists;

/**
 * Several functions composed together.
 * 
 * @author alexander.garbarino
 * @param <F>
 * @param <T>
 */
public class CompositeFunction<F, T> extends AbstractFunction<F, T>
{
    /**
     * Component functions in order of application.
     */
    private final List<Function<?, ?>> _components;

    @SuppressWarnings("unchecked")
    public <M> CompositeFunction(final Function<F, M> innerFunction, final Function<M, T> outerFunction)
    {
        _components = Lists.newArrayList(innerFunction, outerFunction);
    }

    private <M> CompositeFunction(final CompositeFunction<F, M> innerFunction, final Function<M, T> outerFunction)
    {
        _components = Lists.newArrayList(innerFunction._components);
        _components.add(outerFunction);
    }

    @SuppressWarnings("unchecked")
    @Override
    public T apply(final F input)
    {
        Object result = input;
        for(final Function<?, ?> component: _components)
        {
            result = ((Function<Object, Object>)component).apply(result);
        }
        return (T)result;
    }

    @SuppressWarnings({"unchecked", "rawtypes"})
    @Override
    public <NewT> CompositeFunction<F, NewT> andThen(final Function<T, NewT> outerFunction)
    {
        return new CompositeFunction(this, outerFunction);
    }

    @Override
    public String toString()
    {
        return Joiner.on("->").join(_components);
    }
}
