package ohd.hseb.hefs.utils;

import static com.google.common.collect.Lists.newArrayList;

import java.util.List;

/**
 * Interface for any {@link Decorator} to allow access to the delegate object.
 * 
 * @author alexander.garbarino
 * @param <A>
 */
public interface Decorator<A>
{
    /**
     * Retrieves the delegate for this decorator.
     * 
     * @return
     */
    public A delegate();

    public static abstract class Tools
    {
        /**
         * Retrieves a list of decorators applied to {@code object}.
         * 
         * @param object the object to retrieve the decorators for
         * @return the list of all decorators on {@code object}
         */
        public static List<Decorator<?>> getDecorators(Object object)
        {
            List<Decorator<?>> list = newArrayList();
            while(object instanceof Decorator<?>)
            {
                list.add((Decorator<?>)object);
                object = ((Decorator<?>)object).delegate();
            }
            return list;
        }

        /**
         * Strips all decorators from the target object.
         * 
         * @param object the object to find the final delegate of
         * @return the final delegate of {@code object}.
         */
        public static Object getUndecorated(Object object)
        {
            while(object instanceof Decorator<?>)
            {
                object = ((Decorator<?>)object).delegate();
            }
            return object;
        }
    }
}
