package ohd.hseb.hefs.utils;

/**
 * A disjoint union - may be either the left or the right value.
 * 
 * @author alexander.garbarino
 * @param <L>
 * @param <R>
 */
public class Disjoint<L, R>
{
    private final L _left;
    private final R _right;
    private final boolean _usedRight;

    private Disjoint(final L left, final R right, final boolean usedRight)
    {
        _left = left;
        _right = right;
        _usedRight = usedRight;
    }

    @SuppressWarnings({"rawtypes", "unchecked"})
    public static <L, R> Disjoint<L, R> makeLeft(final L value)
    {
        return new Disjoint(value, null, false);
    }

    @SuppressWarnings({"rawtypes", "unchecked"})
    public static <L, R> Disjoint<L, R> makeRight(final R value)
    {
        return new Disjoint(null, value, true);
    }

    public boolean isLeft()
    {
        return !_usedRight;
    }

    public boolean isRight()
    {
        return _usedRight;
    }

    public L asLeft()
    {
        if(_usedRight)
        {
            throw new IllegalStateException("Is a right value.");
        }
        return _left;
    }

    public R asRight()
    {
        if(!_usedRight)
        {
            throw new IllegalStateException("Is a left value.");
        }
        return _right;
    }
}
