package ohd.hseb.hefs.utils;

import static com.google.common.base.Objects.equal;
import net.jcip.annotations.Immutable;

import com.google.common.base.Objects;

/**
 * A simple immutable pairing of objects.
 * 
 * @author Hank.Herr
 * @param <A> Type of first object.
 * @param <B> Type of second object.
 */
@Immutable
public class Dyad<A, B>
{
    public final A _first;
    public final B _second;

    public Dyad(A first, B second)
    {
        _first = first;
        _second = second;
    }

    public A getFirst()
    {
        return _first;
    }

    public B getSecond()
    {
        return _second;
    }

    @Override
    public String toString()
    {
        return String.format("(%s,%s)", _first, _second);
    }

    @Override
    public int hashCode()
    {
        return Objects.hashCode(_first, _second);
    }

    @Override
    public boolean equals(Object other)
    {
        if(this == other)
        {
            return true;
        }

        if(!(other instanceof Dyad))
        {
            return false;
        }

        Dyad that = (Dyad)other;
        return equal(this._first, that._first) && equal(this._second, that._second);
    }
}
