package ohd.hseb.hefs.utils;

import java.util.Collection;
import java.util.Iterator;

import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.common.collect.Collections2;
import com.google.common.collect.ForwardingCollection;
import com.google.common.collect.Iterators;

/**
 * A collection split on a predicate - all items satisfying the predicate are put at the head of the collection, all
 * that don't are put at the end.
 * 
 * @author alexander.garbarino
 */
public class SplitCollection<E> extends ForwardingCollection<E>
{
    private final Collection<E> _delegate;
    private final Predicate<E> _predicate;

    private final Collection<E> _headCollection;
    private final Collection<E> _tailCollection;

    public SplitCollection(Collection<E> delegate, Predicate<E> predicate)
    {
        _delegate = delegate;
        _predicate = predicate;

        _headCollection = Collections2.filter(_delegate, _predicate);
        _tailCollection = Collections2.filter(_delegate, Predicates.not(_predicate));
    }

    public Collection<E> getHeadView()
    {
        return _headCollection;
    }

    public Collection<E> getTailView()
    {
        return _tailCollection;
    }

    @Override
    protected Collection<E> delegate()
    {
        return _delegate;
    }

    @Override
    public Iterator<E> iterator()
    {
        return Iterators.concat(_headCollection.iterator(), _tailCollection.iterator());
    }

    @Override
    public Object[] toArray()
    {
        return standardToArray();
    }

    @Override
    public <T> T[] toArray(T[] a)
    {
        return standardToArray(a);
    }
}
