package ohd.hseb.hefs.utils;

import static com.google.common.base.Objects.equal;
import net.jcip.annotations.Immutable;

import com.google.common.base.Objects;

/**
 * A simple immutable triplet of objects.
 * 
 * @author Hank.Herr
 * @param <A> Type of first object.
 * @param <B> Type of second object.
 * @param <C> Type of third object.
 */
@Immutable
public class Triad<A, B, C>
{
    public final A _first;
    public final B _second;
    public final C _third;

    public Triad(final A first, final B second, final C third)
    {
        _first = first;
        _second = second;
        _third = third;
    }

    public A getFirst()
    {
        return _first;
    }

    public B getSecond()
    {
        return _second;
    }

    public C getThird()
    {
        return _third;
    }

    @Override
    public String toString()
    {
        return String.format("(%s,%s,%s)", _first, _second, _third);
    }

    @Override
    public int hashCode()
    {
        return Objects.hashCode(_first, _second, _third);
    }

    @Override
    public boolean equals(final Object other)
    {
        if(this == other)
        {
            return true;
        }

        if(!(other instanceof Triad))
        {
            return false;
        }

        final Triad that = (Triad)other;
        return equal(this._first, that._first) && equal(this._second, that._second) && equal(this._third, that._third);
    }
}
