package ohd.hseb.hefs.utils;

import ohd.hseb.hefs.utils.notify.NoticeForwarder;
import ohd.hseb.hefs.utils.notify.Notifier;

import com.google.common.base.Objects;
import com.google.common.base.Supplier;

/**
 * General class for holding a variable. If the contained variable implements {@link Notifier}, then {@code Variable}
 * will forward all posted events.
 * 
 * @author alexander.garbarino
 * @param <T>
 */
public class Variable<T> extends NoticeForwarder implements Supplier<T>
{
    private T _value;

    public Variable()
    {
    }

    public Variable(final T value)
    {
        set(value);
    }

    @Override
    public T get()
    {
        return _value;
    }

    public void set(final T value)
    {
        set(value, this);
    }

    @SuppressWarnings({"rawtypes", "unchecked"})
    public void set(final T value, final Object source)
    {
        final T prev = _value;
        if(prev instanceof Notifier)
        {
            ((Notifier)prev).unregister(this);
        }
        _value = value;
        if(_value instanceof Notifier)
        {
            ((Notifier)_value).register(this);
        }
        post(new VariableSetNotice(source, this, prev, _value));
    }

    @Override
    public boolean equals(final Object other)
    {
        if(this == other)
        {
            return true;
        }

        if(!(other instanceof Variable<?>))
        {
            return false;
        }

        final Variable<?> that = (Variable<?>)other;
        return Objects.equal(this._value, that._value);
    }

    @Override
    public int hashCode()
    {
        return ~_value.hashCode();
    }
}
