package ohd.hseb.hefs.utils;

import ohd.hseb.hefs.utils.notify.ObjectModifiedNotice;

import com.google.common.eventbus.Subscribe;

public class VariableSetNotice<T> extends ObjectModifiedNotice<Variable<T>>
{
    private final T _previous;
    private final T _new;

    public VariableSetNotice(Object source, Variable<T> target, T previousValue, T newValue)
    {
        super(source, target);
        _previous = previousValue;
        _new = newValue;
    }

    public VariableSetNotice(Variable<T> sourceAndTarget, T previousValue, T newValue)
    {
        super(sourceAndTarget);
        _previous = previousValue;
        _new = newValue;
    }

    public T getPreviousValue()
    {
        return _previous;
    }

    public T getNewValue()
    {
        return _new;
    }

    @Override
    public String toString()
    {
        return String.format("VariableSetNotice: Set %s from %s. [%s]", getTarget(), _previous, getSource());
    }

    public interface Subscriber<T>
    {
        @Subscribe
        void reactToVariableSet(VariableSetNotice<? extends T> notice);
    }
}
