package ohd.hseb.hefs.utils;

import java.io.File;
import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.zip.ZipFile;

import com.google.common.io.InputSupplier;

public class ZipEntryInputSupplier implements InputSupplier<InputStream>
{
    private final File _file;
    private final String _entryName;

    public ZipEntryInputSupplier(File file, String entryName)
    {
        _file = file;
        _entryName = entryName;
    }

    @Override
    public InputStream getInput() throws IOException
    {
        return new CloseZipFileInputStream(new ZipFile(_file));
    }

    private class CloseZipFileInputStream extends FilterInputStream
    {
        private final ZipFile _zip;

        protected CloseZipFileInputStream(ZipFile zip) throws IOException
        {
            super(zip.getInputStream(zip.getEntry(_entryName)));
            _zip = zip;
        }

        @Override
        public void close() throws IOException
        {
            super.close();
            _zip.close();
        }
    }
}
