package ohd.hseb.hefs.utils;

import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Enumeration;
import java.util.List;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import java.util.zip.ZipOutputStream;

import ohd.hseb.hefs.utils.tools.StreamTools;

import com.google.common.collect.Lists;
import com.google.common.io.ByteStreams;
import com.google.common.io.Files;

public class ZipUpdater
{
    private final File _file;
    private File _tempFile;
    private ZipOutputStream _out;
    private final List<String> _overridenFiles;

    public ZipUpdater(final File zipFile)
    {
        _file = zipFile;
        _tempFile = null;
        _out = null;
        _overridenFiles = Lists.newArrayList();
    }

    public void start() throws IOException
    {
        _tempFile = File.createTempFile("zipupdate", ".zip");
        _out = new ZipOutputStream(new BufferedOutputStream(new FileOutputStream(_tempFile)));
        _overridenFiles.clear();
    }

    /**
     * @param dataFile the file holding the data
     * @param entryFile the place to put the entry in the zip file
     * @throws IOException
     */
    public void write(final File dataFile, final File entryFile) throws IOException
    {
        final ZipEntry entry = new ZipEntry(entryFile.getPath());
        _out.putNextEntry(entry);
        final InputStream in = new FileInputStream(dataFile);
        ByteStreams.copy(in, _out);
        in.close();
        _overridenFiles.add(entryFile.getPath());
    }

    public void stop() throws IOException
    {
        ZipFile zip = null;
        try
        {
            if(_file.exists())
            {
                zip = new ZipFile(_file);
                final Enumeration<? extends ZipEntry> entries = zip.entries();
                while(entries.hasMoreElements())
                {
                    final ZipEntry entry = entries.nextElement();
                    if(_overridenFiles.contains(entry.getName()))
                    {
                        continue;
                    }
                    final InputStream in = zip.getInputStream(entry);
                    _out.putNextEntry(entry);
                    ByteStreams.copy(in, _out);
                    _out.closeEntry();
                }
            }
        }
        finally
        {
            StreamTools.closeStream(zip);
            _out.flush();
            _out.close();
        }
        Files.move(_tempFile, _file);
    }
}
