package ohd.hseb.hefs.utils.adapter;

import java.io.Serializable;

import org.apache.logging.log4j.Level;
import org.apache.logging.log4j.core.Appender;
import org.apache.logging.log4j.core.ErrorHandler;
import org.apache.logging.log4j.core.Layout;
import org.apache.logging.log4j.core.LogEvent;
import org.apache.logging.log4j.core.appender.ConsoleAppender;
import org.apache.logging.log4j.core.layout.PatternLayout;

import ohd.hseb.util.Logger;
import ohd.hseb.util.fews.Diagnostics;


import ohd.hseb.util.fews.FewsAdapterDAO;



public class HEFSAdapterLogAppender implements Appender
{
	
	ConsoleAppender _appender = null;

    private final Diagnostics _diagnostics = new Diagnostics();

    
    public HEFSAdapterLogAppender(String name, final PatternLayout layout, ConsoleAppender.Target target)
    {
    	_appender = ConsoleAppender.newBuilder()
        		.withName(name)
                .withLayout(layout)
                .setTarget(target)              
                .build();    	      
    }	
    

    public void outputDiagnostics(final String diagFileName) throws Exception
    {
        FewsAdapterDAO.writeLog(_diagnostics, diagFileName);
    }

    public void outputDiagnostics()
    {
        System.out.println("***" + _diagnostics.getListOfDiagnosticsAsString());
    }

    public void turnOnDebugLogging()
    {
        _diagnostics.setPrintDebugInfo(1);
    }


    
    @Override
    public void append(final LogEvent evt)
    {    	
        if(evt.getLevel() == Level.DEBUG)
        {
            _diagnostics.log(Logger.DEBUG, evt.getMessage().getFormattedMessage());
        }
        else if(evt.getLevel() == Level.INFO)
        {
            _diagnostics.log(Logger.INFO, (String)evt.getMessage().getFormattedMessage());
        }
        else if(evt.getLevel() == Level.WARN)
        {
            _diagnostics.log(Logger.WARNING, evt.getMessage().getFormattedMessage());
        }
        else if(evt.getLevel() == Level.ERROR)
        {
            _diagnostics.log(Logger.ERROR, evt.getMessage().getFormattedMessage());
        }
        else if(evt.getLevel() == Level.FATAL)
        {
            _diagnostics.log(Logger.FATAL, evt.getMessage().getFormattedMessage());
        }
    }
 

	@Override
	public State getState() {
		// TODO Auto-generated method stub
		return _appender.getState();
	}

	@Override
	public void initialize() {
		// TODO Auto-generated method stub
		_appender.initialize();
		
	}

	@Override
	public boolean isStarted() {
		// TODO Auto-generated method stub
		return _appender.isStarted();
	}

	@Override
	public boolean isStopped() {
		// TODO Auto-generated method stub
		return _appender.isStopped();
	}

	@Override
	public void start() {
		_appender.start();
		
	}

	@Override
	public void stop() {
		_appender.stop();
		
	}



	@Override
	public ErrorHandler getHandler() {
		// TODO Auto-generated method stub
		return _appender.getHandler();
	}

	@Override
	public Layout<? extends Serializable> getLayout() {
		// TODO Auto-generated method stub
		return _appender.getLayout();
	}

	@Override
	public String getName() {
		// TODO Auto-generated method stub
		return _appender.getName();
	}

	@Override
	public boolean ignoreExceptions() {
		// TODO Auto-generated method stub
		return _appender.ignoreExceptions();
	}

	@Override
	public void setHandler(ErrorHandler arg0) {
		// TODO Auto-generated method stub
		_appender.setHandler(arg0);
	}

}
