package ohd.hseb.hefs.utils.adapter;

import java.util.Properties;

/**
 * Interface for objects that store property values. It is used in the {@link HEFSModelAdapter} default run-information
 * reading method.
 * 
 * @author hankherr
 */
public interface PropertyVariable<T>
{

    /**
     * @param props The properties from which to read.
     * @throws Exception If the property value is badly formatted, or if the property is required but not found.
     */
    public void read(Properties props) throws Exception;

    /**
     * This is called after ALL properties have been read without an error. It allows for actions to take place once it
     * is known that the properties are read successfully.
     * 
     * @throws Exception If a problem occurs during finalizing the property.
     */
    public void processAfterSuccessfulRead() throws Exception;

    /**
     * @return The name of the property.
     */
    public String getPropertyName();
}
