package ohd.hseb.hefs.utils.adapter;

import java.util.Properties;

import ohd.hseb.hefs.utils.xml.XMLVariable;

/**
 * Stores the property variable in an {@link XMLVariable} instance whose {@link XMLVariable#getXMLTagName()} specifies
 * the name of the property. A {@link #_required} is provided to specify if the property is required.
 * 
 * @author hankherr
 * @param T The value type of the property (not the key!). It dictates the type of {@link XMLVariable} passed into the
 *            constructor and the return of the {@link #getValue()} method.
 */
public class SimplePropertyVariable<T> implements PropertyVariable
{
    private final boolean _required;
    private final XMLVariable<T> _variable;

    public SimplePropertyVariable(final XMLVariable<T> variable, final boolean required)
    {
        _variable = variable;
        _required = required;
    }

    public T getValue()
    {
        return _variable.get();
    }

    public void setValue(final T value)
    {
        _variable.set(value);
    }

    @Override
    public void read(final Properties props) throws Exception
    {
        final String varStr = props.getProperty(_variable.getXMLTagName());
        if(varStr == null)
        {
            if(_required)
            {
                throw new Exception("Property " + _variable.getXMLTagName() + " was not provided.");
            }
        }
        else
        {
            _variable.setValueOfElement(_variable.getXMLTagName(), varStr);
            _variable.finalizeReading();
        }
    }

    @Override
    public String getPropertyName()
    {
        return _variable.getXMLTagName();
    }

    @Override
    public void processAfterSuccessfulRead() throws Exception
    {
        //Does nothing by default.
    }
}
