package ohd.hseb.hefs.utils.arguments;

import java.awt.BorderLayout;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;

import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.border.EtchedBorder;

import ohd.hseb.hefs.utils.gui.tools.HSwingFactory;
import ohd.hseb.hefs.utils.gui.tools.SwingTools;

/**
 * Implemented by any panel designed to edit the parameters of an argument function. It provides an attribute and
 * set/get methods for the edited Argument instance.
 * 
 * @author herrhd
 */
public abstract class ArgumentFunctionParameterEditingPanel extends JPanel
{
    private static final long serialVersionUID = 1L;

    private Argument _editedArgument;

    private ArgumentsProcessor _argumentsProcessor;

    private final JTextField _functionTextField = new JTextField(30);
    private final JTextField _functionValueField = new JTextField(30);

    protected void createDisplay()
    {
        _functionTextField.setEnabled(false);
        _functionValueField.setEnabled(false);

        final JPanel subPanel = createEditingSubPanel();

        final JPanel functionSubPanel = new JPanel(new GridBagLayout());
        GridBagConstraints constraints = SwingTools.returnGridBagConstraints(0,
                                                                             0,
                                                                             1,
                                                                             1,
                                                                             0,
                                                                             1,
                                                                             GridBagConstraints.WEST,
                                                                             GridBagConstraints.BOTH,
                                                                             new Insets(2, 2, 2, 2),
                                                                             0,
                                                                             0);
        functionSubPanel.add(new JLabel("Function Text: "), constraints);
        constraints = SwingTools.returnGridBagConstraints(1,
                                                          0,
                                                          1,
                                                          1,
                                                          1,
                                                          1,
                                                          GridBagConstraints.WEST,
                                                          GridBagConstraints.BOTH,
                                                          new Insets(2, 2, 2, 2),
                                                          0,
                                                          0);
        functionSubPanel.add(_functionTextField, constraints);

        constraints = SwingTools.returnGridBagConstraints(0,
                                                          1,
                                                          1,
                                                          1,
                                                          0,
                                                          1,
                                                          GridBagConstraints.WEST,
                                                          GridBagConstraints.BOTH,
                                                          new Insets(2, 2, 2, 2),
                                                          0,
                                                          0);
        functionSubPanel.add(new JLabel("Function Value: "), constraints);
        constraints = SwingTools.returnGridBagConstraints(1,
                                                          1,
                                                          1,
                                                          1,
                                                          1,
                                                          1,
                                                          GridBagConstraints.WEST,
                                                          GridBagConstraints.BOTH,
                                                          new Insets(2, 2, 2, 2),
                                                          0,
                                                          0);
        functionSubPanel.add(_functionValueField, constraints);

        subPanel.setBorder(HSwingFactory.createTitledBorder(new EtchedBorder(), "Edit Parameters", null));
        functionSubPanel.setBorder(HSwingFactory.createTitledBorder(new EtchedBorder(), "Function Results", null));

        //Put together the overall panel, this
        this.setLayout(new BorderLayout());
        this.add(subPanel, BorderLayout.CENTER);
        this.add(functionSubPanel, BorderLayout.SOUTH);
    }

    protected void updateFields()
    {
        this.makeEditedArgumentReflectPanel();

        final String text = this.getEditedArgument().buildArgumentString(_argumentsProcessor.getArgumentChar());
        this._functionTextField.setText(text);
        this._functionValueField.setText(_argumentsProcessor.replaceArgumentsInString(text));
    }

    public void setEditedArgument(final Argument arg)
    {
        _editedArgument = arg;
    }

    public Argument getEditedArgument()
    {
        return _editedArgument;
    }

    protected void setArgumentsProcessor(final ArgumentsProcessor argProc)
    {
        this._argumentsProcessor = argProc;
    }

    protected ArgumentsProcessor getArgumentsProcessor()
    {
        return this._argumentsProcessor;
    }

    /**
     * Called by ArgumentPopupMenu to make sure the _editedArgument reflects the panel settings. It is called after the
     * JOptionPane that displays the panel is closed.
     */
    public abstract void makeEditedArgumentReflectPanel();

    protected abstract JPanel createEditingSubPanel();

}
