package ohd.hseb.hefs.utils.arguments;

import javax.swing.JComboBox;

/**
 * An editable combobox that allows for arguments to be inserted. It uses a TextFieldComboBoxEditor.
 * 
 * @author hank.herr
 */
public class ArgumentInsertingEditableComboBox extends JComboBox// implements ActionListener, ArgumentPopupMenuListener
{
    private static final long serialVersionUID = 1L;

    private ArgumentsProcessor _argumentsProcessor = null;

    public ArgumentInsertingEditableComboBox(ArgumentsProcessor argProc, Object[] choices)
    {
        super(choices);
        this._argumentsProcessor = argProc;
        setupComboBox();
    }

    public ArgumentInsertingEditableComboBox(ArgumentsProcessor argProc)
    {
        this._argumentsProcessor = argProc;
        setupComboBox();
    }

    public ArgumentInsertingEditableComboBox(DefaultArgumentsProcessor argProc, String initialText)
    {
        this(argProc);
        this.setSelectedItem(initialText);
    }

    private void setupComboBox()
    {
        setEditable(true);
        ArgumentInsertingTextFieldComboBoxEditor editor = new ArgumentInsertingTextFieldComboBoxEditor(_argumentsProcessor);
        setEditor(editor);
    }

    public void setIncludeFunctions(boolean b)
    {
        ((ArgumentInsertingTextField)getEditor()).setIncludeFunctions(b);
    }

}
