package ohd.hseb.hefs.utils.arguments;

import java.awt.event.FocusListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.List;

import javax.swing.JPopupMenu;
import javax.swing.JTextArea;

public class ArgumentInsertingTextArea extends JTextArea implements ArgumentPopupMenuListener
{
    private static final long serialVersionUID = 1L;

    private ArgumentsProcessor _argumentsProcessor = null;

    private boolean _includeFunctions = true;
    private final List<FocusListener> _listenersToRecover = new ArrayList<FocusListener>();

    public ArgumentInsertingTextArea(final ArgumentsProcessor argProc)
    {
        this._argumentsProcessor = argProc;

        this.addMouseListener(new MouseAdapter()
        {
            @Override
            public void mousePressed(final MouseEvent e)
            {
                maybeShowPopup(e);
            }

            @Override
            public void mouseReleased(final MouseEvent e)
            {
                maybeShowPopup(e);
            }

            private void maybeShowPopup(final MouseEvent e)
            {
                if(((JTextArea)e.getSource()).isEnabled())
                {

                    if(e.isPopupTrigger())
                    {
                        final JPopupMenu popup = buildPopupMenu();
                        recordAndRemoveFocusListeners();
                        popup.show(e.getComponent(), e.getX(), e.getY());
                    }
                }
            }

        });
    }

    public void setIncludeFunctions(final boolean b)
    {
        this._includeFunctions = b;
    }

    private void recordAndRemoveFocusListeners()
    {
        for(int i = 0; i < this.getFocusListeners().length; i++)
        {
            this._listenersToRecover.add(this.getFocusListeners()[i]);
        }
        for(int i = 0; i < this.getFocusListeners().length; i++)
        {
            this.removeFocusListener(this.getFocusListeners()[i]);
        }
    }

    private void recoverFocusListeners()
    {
        for(int i = 0; i < this._listenersToRecover.size(); i++)
        {
            this.addFocusListener(this._listenersToRecover.get(i));
        }
        this._listenersToRecover.clear();
    }

    public ArgumentInsertingTextArea(final ArgumentsProcessor argProc, final String initialText)
    {
        this(argProc);
        this.setText(initialText);
    }

    public ArgumentInsertingTextArea(final ArgumentsProcessor argProc,
                                     final String initialText,
                                     final int rows,
                                     final int cols)
    {
        this(argProc, initialText);
        this.setRows(rows);
        this.setColumns(cols);
    }

    protected JPopupMenu buildPopupMenu()
    {
        final ArgumentPopupMenu popupMenu = new ArgumentPopupMenu(this._argumentsProcessor, this._includeFunctions);
        popupMenu.setParentComponentForLocatingDialogs(this);
        popupMenu.addListener(this);
        return popupMenu;
    }

    @Override
    public void argumentChosen(final Argument arg)
    {
        recoverFocusListeners();
        this.requestFocus();
        final String argStr = arg.buildArgumentString(_argumentsProcessor.getArgumentChar());

        if((this.getSelectedText() != null) && (this.getSelectedText().length() > 0))
        {
            final int startIndex = this.getSelectionStart();
            final int endIndex = this.getSelectionEnd();
            setText(this.getText().substring(0, startIndex) + argStr + this.getText().substring(endIndex));
            setCaretPosition(startIndex + argStr.length());
        }
        else
        {
            final int caretPos = this.getCaretPosition();
            setText(this.getText().substring(0, caretPos) + argStr + this.getText().substring(caretPos));
            setCaretPosition(caretPos + argStr.length());
        }
    }

    @Override
    public void clearFieldChosen()
    {
        recoverFocusListeners();
        this.requestFocus();
        this.setText("");
    }

}
