package ohd.hseb.hefs.utils.arguments;

import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.List;

import javax.swing.JPopupMenu;
import javax.swing.JTextField;

public class ArgumentInsertingTextField extends JTextField implements ArgumentPopupMenuListener
{
    private static final long serialVersionUID = 1L;

    private ArgumentsProcessor _argumentsProcessor = null;

    private final List<FocusListener> _listenersToRecover = new ArrayList<FocusListener>();

    private boolean _includeFunctions = true;

    public ArgumentInsertingTextField()
    {
        this(null);
    }

    public ArgumentInsertingTextField(final ArgumentsProcessor argProc)
    {
        this._argumentsProcessor = argProc;

        addFocusListener(new FocusAdapter()
        {
            @Override
            public void focusGained(final FocusEvent e)
            {
                selectAll();
            }
        });

        if(_argumentsProcessor != null)
        {
            this.addMouseListener(new MouseAdapter()
            {
                @Override
                public void mousePressed(final MouseEvent e)
                {
                    maybeShowPopup(e);
                }

                @Override
                public void mouseReleased(final MouseEvent e)
                {
                    maybeShowPopup(e);
                }

                private void maybeShowPopup(final MouseEvent e)
                {
                    if(((JTextField)e.getSource()).isVisible())
                    {
                        if((e.isPopupTrigger()) && (_argumentsProcessor != null))
                        {
                            final JPopupMenu popup = buildPopupMenu();
                            recordAndRemoveFocusListeners();
                            popup.show(e.getComponent(), e.getX(), e.getY());
                        }
                    }
                }

            });
        }
    }

    private void recordAndRemoveFocusListeners()
    {
        for(int i = 0; i < this.getFocusListeners().length; i++)
        {
            this._listenersToRecover.add(this.getFocusListeners()[i]);
        }
        for(int i = 0; i < _listenersToRecover.size(); i++)
        {
            this.removeFocusListener(_listenersToRecover.get(i));
        }
    }

    private void recoverFocusListeners()
    {
        for(int i = 0; i < this._listenersToRecover.size(); i++)
        {
            this.addFocusListener(this._listenersToRecover.get(i));
        }
        this._listenersToRecover.clear();
    }

    public ArgumentInsertingTextField(final ArgumentsProcessor argProc, final String initialText)
    {
        this(argProc);
        this.setText(initialText);
    }

    public ArgumentInsertingTextField(final ArgumentsProcessor argProc, final String initialText, final int cols)
    {
        this(argProc, initialText);
        this.setColumns(cols);
    }

    public void setIncludeFunctions(final boolean b)
    {
        this._includeFunctions = b;
    }

    protected JPopupMenu buildPopupMenu()
    {
        final ArgumentPopupMenu popupMenu = new ArgumentPopupMenu(this._argumentsProcessor, _includeFunctions);
        popupMenu.setParentComponentForLocatingDialogs(this);
        popupMenu.addListener(this);
        return popupMenu;
    }

    public ArgumentsProcessor getArguments()
    {
        return this._argumentsProcessor;
    }

    @Override
    public void argumentChosen(final Argument arg)
    {
        recoverFocusListeners();
        requestFocus();
        final String argStr = arg.buildArgumentString(_argumentsProcessor.getArgumentChar());

        if((this.getSelectedText() != null) && (this.getSelectedText().length() > 0))
        {
            final int startIndex = this.getSelectionStart();
            final int endIndex = this.getSelectionEnd();
            setText(this.getText().substring(0, startIndex) + argStr + this.getText().substring(endIndex));
            setCaretPosition(startIndex + argStr.length());
        }
        else
        {
            final int caretPos = this.getCaretPosition();
            setText(this.getText().substring(0, caretPos) + argStr + this.getText().substring(caretPos));
            setCaretPosition(caretPos + argStr.length());
        }
    }

    @Override
    public void clearFieldChosen()
    {
        recoverFocusListeners();
        requestFocus();
        setText("");
    }

}
