package ohd.hseb.hefs.utils.arguments;

import java.awt.Component;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.util.ArrayList;
import java.util.List;

import javax.swing.ComboBoxEditor;
import javax.swing.JComboBox;
import javax.swing.JComponent;

import ohd.hseb.hefs.utils.gui.components.TextFieldComboBoxEditorListener;

/**
 * To implement this, first create a JComboBox object and then set the editor to an instance of this class
 * (TextFieldComboBoxEditor) i.e. <br>
 * <br>
 * JComboBox comboBox = new JComboBox();<br>
 * combobox.setEditor( new ArgumentInsertingTextFieldComboBoxEditor() ); <br>
 * <br>
 * This allows for arguments to be inserted into the editing text field via a popup-menu. It will also fire a message to
 * any added TextFieldComboBoxEditorListener whenever a modification is made to the field either via a key-stroke or a
 * selection from the argument pop-up menu.
 * 
 * @author Hank Herr
 */
public class ArgumentInsertingTextFieldComboBoxEditor extends ArgumentInsertingTextField implements ComboBoxEditor
{
    private static final long serialVersionUID = 1L;

    private final List<TextFieldComboBoxEditorListener> _listeners = new ArrayList<TextFieldComboBoxEditorListener>();

    public ArgumentInsertingTextFieldComboBoxEditor()
    {
        this(null);
    }

    public ArgumentInsertingTextFieldComboBoxEditor(final ArgumentsProcessor argProc)
    {
        super(argProc);

        final JComboBox tempbox = new JComboBox();
        this.setBorder(((JComponent)tempbox.getEditor().getEditorComponent()).getBorder());

        addKeyListener(new KeyAdapter()
        {
            @Override
            public void keyTyped(final KeyEvent e)
            {
                fireTextFieldModified();
            }
        });
    }

    private void fireTextFieldModified()
    {
        for(int i = 0; i < _listeners.size(); i++)
        {
            this._listeners.get(i).textFieldValueModified();
        }
    }

    public void addListener(final TextFieldComboBoxEditorListener listener)
    {
        this._listeners.add(listener);
    }

    public void removeListener(final TextFieldComboBoxEditorListener listener)
    {
        this._listeners.remove(listener);
    }

    @Override
    public Component getEditorComponent()
    {
        return this;
    }

    @Override
    public Object getItem()
    {
        return this.getText();
    }

    @Override
    public void setItem(final Object arg0)
    {
        if(arg0 == null)
        {
            setText(null);
        }
        else
        {
            this.setText(arg0.toString());
        }
    }

    @Override
    public void argumentChosen(final Argument arg)
    {
        super.argumentChosen(arg);
        this.fireTextFieldModified();
    }

    @Override
    public void clearFieldChosen()
    {
        super.clearFieldChosen();
        this.fireTextFieldModified();
    }

}
